<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class InquiryAnswer extends Model 
{

    protected $table = 'inquiry_answers';
    public $timestamps = true;
    protected $fillable = array('inquiry_id', 'question_id');
    protected $visible = array('inquiry_id', 'question_id');

    public function question()
    {
        return $this->belongsTo('App\Models\Question', 'question_id');
    }

    public function inquiry()
    {
        return $this->belongsTo('App\Models\Inquiry', 'inquiry_id');
    }

}